Attribute VB_Name = "CreateTableFromDims"
Option Explicit

Private app As ProDESKTOP
Private api As helm

'localisation strings in resource file
'table strings
'tableTitle = LoadResString(116)
'tableLabel = LoadResString(114)
'tableValue = LoadResString(115)

'dialog strings
'noDrg = LoadResString(117)
'noDimsSel = LoadResString(118)

Public Sub CreateTableFromSelectedDims()
    
    Set app = CreateObject("ProDESKTOP.Application")
    'app.SetVisible True
    
    Set api = app.TakeHelm
    
    On Error GoTo noDoc
    Dim doc As DrawingDocument
    Set doc = app.GetActiveDoc
    
    Dim drg As aDrawing
    Set drg = doc.GetDrawing
    On Error GoTo 0
    
    Dim sheet As aSheet
    Set sheet = doc.GetActiveSheet
    On Error GoTo 0
    
    Dim sel As ObjectSet
    Set sel = app.GetClass("ObjectSet").CreateAObjectSet()
    Set sel = doc.GetSelection("DimensionCallout")
    
    If sel.GetCount = 0 Then
        MsgBox LoadResString(118)
        app.ReleaseHelm api
        Exit Sub
    End If
    
    Dim table As aTable
    Set table = CreateDimTable(sheet, 2)  'only 2 columns
        
    PopulateTable drg, table, sel
    
    api.CommitCalls LoadResString(119), False
    app.ReleaseHelm api
    
    doc.ClearSelection
    
    Exit Sub
    
noDoc:
    MsgBox LoadResString(117)
    
End Sub

Private Function CreateDimTable(sheet As aSheet, nColumns As Long) As aTable
    
    Dim pos As zVector
    Set pos = app.GetClass("Vector").CreateVector(0, 0, 0)   ' we'll set the actual position later

    Dim textHeight As Double
    textHeight = 0.005  '5mm

    Dim columnWidth As Double
    columnWidth = 0.05  '50mm

    ' TableColumn alignment values
    '    alignLeft = 0
    '    alignCenter = 1
    '    alignRight = 2

    Dim columnAlignment As Long
    columnAlignment = 1   'alignCenter

    Dim table As aTable
    Set table = app.GetClass("Table").CreateTable(pos, textHeight, nColumns, columnWidth, columnAlignment)

    sheet.AddTable table

    table.SetInverted False

    ' put table in the top right corner
    Set pos = app.GetClass("Vector").CreateVector(sheet.GetWidth, sheet.GetHeight, 0)

    ' Table anchor values
    '    anchorTopLeft = 0
    '    anchorTopRight = 1
    '    anchorBottomLeft = 2
    '    anchorBottomRight = 3
    
    Dim anchor As Long
    anchor = 1  'anchorTopRight
    table.SetAnchor anchor
    table.SetAnchorPoint anchor, pos
    
    Dim nodeIndex As Long, indent As Long
    nodeIndex = 0
    indent = 1
    
    table.SetIndent nodeIndex, indent
    table.SetTitle nodeIndex, LoadResString(116)
    
    nodeIndex = 1
    table.SetIndent nodeIndex, indent
    table.SetTitle nodeIndex, LoadResString(114)
    
    nodeIndex = 2
    table.SetIndent nodeIndex, indent
    table.SetTitle nodeIndex, LoadResString(115)
    
    Set CreateDimTable = table
    
End Function

Private Sub PopulateTable(drg As aDrawing, table As aTable, selectedDims As ObjectSet)
    
    Dim it As iterator, dimCallout As aDimensionCallout
    Set it = app.GetClass("it").CreateAObjectIt(selectedDims)
    it.start
    
    Do While it.IsActive
        Set dimCallout = it.Current
        InsertRow drg, table, dimCallout
        it.Next
    Loop

End Sub

Private Sub InsertRow(drg As aDrawing, table As aTable, dimCallout As aDimensionCallout)
    
    table.InsertRow -1
    
    Dim row As Long
    row = table.GetRowCount - 1
    
    Dim nodes As Long
    nodes = table.GetNodeCount
    
    Dim labelColumn As aTableColumn, valueColumn As aTableColumn
    Set labelColumn = table.GetColumn(1)
    Set valueColumn = table.GetColumn(2)
    
    Dim labelColumnTableCell As aTableCell, valueColumnTableCell As aTableCell
    Set labelColumnTableCell = labelColumn.GetCell(row)
    Set valueColumnTableCell = valueColumn.GetCell(row)
    
    Dim note As aNote, label As String
    GetLabelLetter row, label
    
    Set note = app.GetClass("Note").CreateNote(drg, label)
    
    Dim noteCallout As aNoteCallout
    Set noteCallout = app.GetClass("NoteCallout").CreateNoteCallout(note)

    Dim origin As zVector
    Set origin = app.GetClass("Vector").CreateVector(0, 0, 0)
    
    Dim calloutGroup As aCalloutGroup
    Set calloutGroup = app.GetClass("CalloutGroup").CreateCalloutGroup(noteCallout, origin, table.GetTextHeight)
    
    labelColumnTableCell.SetCalloutGroup calloutGroup
    
    'add label to dimension
    Dim dimCalloutGroup As aCalloutGroup
    Set dimCalloutGroup = dimCallout.GetParent("CalloutGroup")
    'create notecallout using previous note
    Dim labelCallout As aNoteCallout
    Set labelCallout = app.GetClass("NoteCallout").CreateNoteCallout(note)
    
    dimCalloutGroup.InsertCallout labelCallout, dimCallout
    
    'create value calloutgroup
    Set calloutGroup = app.GetClass("CalloutGroup").CreateCalloutGroup(dimCallout, origin, table.GetTextHeight)
    
    valueColumnTableCell.SetCalloutGroup calloutGroup
    
End Sub


Private Function GetLabelLetter(ByVal i As Integer, letter As String) As Boolean
    'start at A = chr(65) to Z = chr(90)
    'avoid O (79), I(73), Q(81) as they look like numbers
    'wrap to AA, AB, etc
    
    If i > 48 Then
        MsgBox LoadResString(120)
        GetLabelLetter = False
        Exit Function
    End If
    
    i = i + 65
    
    Dim retString As String

    'adjust if past Z (90), taking into account adjustments below...
    If i > 90 - 3 Then
        i = i - (90 - 3 - 64)
        retString = "A" & Chr(i)
        GoTo returnVal
    End If

    If i >= 73 And i < 90 Then
            i = i + 1
        If i >= 79 And i < 90 Then
                i = i + 1
            If i >= 81 And i < 90 Then
                i = i + 1
            End If
        End If
        retString = Chr(i)
    Else
        retString = Chr(i)
    End If
    
    
returnVal:
    letter = retString
    GetLabelLetter = True
    
End Function
